<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $table = 'settings';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = ['name', 'value', 'created_by'];

    // If value is JSON, return decoded; else return raw string
    public function getValueAttribute($value)
    {
        if (is_null($value)) return null;
        $decoded = json_decode($value, true);
        return (json_last_error() === JSON_ERROR_NONE) ? $decoded : $value;
    }

    // Accept array/object => store JSON; scalars => store as string
    public function setValueAttribute($value): void
    {
        if (is_array($value) || is_object($value)) {
            $this->attributes['value'] = json_encode($value, JSON_UNESCAPED_UNICODE);
        } elseif (is_null($value)) {
            $this->attributes['value'] = null;
        } else {
            $this->attributes['value'] = (string) $value;
        }
    }
}
