<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $table = 'invoices';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = [
        'invoice_id','customer_id','issue_date','due_date','send_date',
        'category_id','ref_number','status','shipping_display','discount_apply',
        'created_by',
    ];

    protected $casts = [
        'issue_date'       => 'date',
        'due_date'         => 'date',
        'send_date'        => 'date',
        'status'           => 'integer',
        'shipping_display' => 'boolean',
        'discount_apply'   => 'boolean',
    ];

    // Relationships
    public function customer()
    {
        return $this->belongsTo(\App\Models\Customer::class, 'customer_id');
    }

    // Virtual property: is_overdue
    protected $appends = ['is_overdue'];
    public function getIsOverdueAttribute(): bool
    {
        return $this->due_date !== null
            && $this->due_date->isPast()
            && in_array($this->status, [0,1,2]); // unpaid/partial/etc. adjust as you like
    }
}
