<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class DucumentUpload extends Model
{
    protected $table = 'ducument_uploads'; // keep the DB name as-is (typo and all)
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = [
        'name','role','document','description','created_by',
    ];

    protected $appends = ['document_url'];

    public function getDocumentUrlAttribute(): ?string
    {
        return $this->document ? Storage::disk('public')->url($this->document) : null;
    }
}
