<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    protected $table = 'customers';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = [
        'customer_id','name','email','tax_number','contact','avatar',
        'created_by','is_active','email_verified_at',
        'billing_name','billing_country','billing_state','billing_city','billing_phone','billing_zip','billing_address',
        'shipping_name','shipping_country','shipping_state','shipping_city','shipping_phone','shipping_zip','shipping_address',
        'lang','balance','remember_token',
    ];

    protected $hidden = ['remember_token'];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_active'         => 'boolean',
        'balance'           => 'decimal:2',
    ];
}
