<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateInvoiceRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $userId = $this->user()->id ?? 0;
        $id = $this->route('invoice'); // numeric primary key

        return [
            'invoice_id'  => [
                'sometimes','required','integer',
                Rule::unique('invoices','invoice_id')
                    ->where(fn($q)=>$q->where('created_by',$userId))
                    ->ignore($id),
            ],
            'customer_id' => ['sometimes','required','integer','exists:customers,id'],
            'issue_date'  => ['sometimes','required','date'],
            'due_date'    => ['sometimes','required','date','after_or_equal:issue_date'],
            'send_date'   => ['sometimes','nullable','date'],
            'category_id' => ['sometimes','required','integer'],
            'ref_number'  => ['sometimes','nullable','string'],
            'status'      => ['sometimes','nullable','integer'],
            'shipping_display' => ['sometimes','nullable','boolean'],
            'discount_apply'   => ['sometimes','nullable','boolean'],
        ];
    }
}
