<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreVenderRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $userId = $this->user()->id ?? 0;

        return [
            'vender_id' => [
                'required','integer',
                Rule::unique('venders','vender_id')
                    ->where(fn($q) => $q->where('created_by',$userId)),
            ],
            'name'                 => 'nullable|string|max:191',
            'email'                => [
                'nullable','email','max:191',
                Rule::unique('venders','email')
                    ->where(fn($q) => $q->where('created_by',$userId)),
            ],
            'company_name'         => 'nullable|string|max:191',
            'company_legal_name'   => 'nullable|string|max:191',
            'company_industry'     => 'nullable|string|max:191',
            'company_entity_type'  => 'nullable|string|max:191',
            'company_email'        => 'nullable|email|max:191',
            'company_website'      => 'nullable|string|max:191',
            'registration_number'  => 'nullable|string|max:191',
            'vat_number'           => 'nullable|string|max:191',
            'company_location_type'=> 'nullable|string|max:191',
            'company_address'      => 'nullable|string',
            'company_city'         => 'nullable|string',
            'company_state'        => 'nullable|string',
            'company_zipcode'      => 'nullable|string',
            'company_telephone'    => 'nullable|string|max:191',
            'tax_number'           => 'nullable|string|max:191',
            'password'             => 'nullable|string|min:8|max:191',
            'contact'              => 'nullable|string|max:191',
            'avatar'               => 'nullable|string|max:100',
            'is_active'            => 'nullable|boolean',
            'billing_name'         => 'nullable|string|max:191',
            'billing_country'      => 'nullable|string|max:191',
            'billing_state'        => 'nullable|string|max:191',
            'billing_city'         => 'nullable|string|max:191',
            'billing_phone'        => 'nullable|string|max:191',
            'billing_zip'          => 'nullable|string|max:191',
            'billing_address'      => 'nullable|string',
            'shipping_name'        => 'nullable|string|max:191',
            'shipping_country'     => 'nullable|string|max:191',
            'shipping_state'       => 'nullable|string|max:191',
            'shipping_city'        => 'nullable|string|max:191',
            'shipping_phone'       => 'nullable|string|max:191',
            'shipping_zip'         => 'nullable|string|max:191',
            'shipping_address'     => 'nullable|string',
            'lang'                 => 'nullable|string|max:191',
            'balance'              => 'nullable|numeric',
        ];
    }
}
