<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreInvoiceRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $userId = $this->user()->id ?? 0;

        return [
            'invoice_id'  => [
                'required','integer',
                Rule::unique('invoices','invoice_id')
                    ->where(fn($q)=>$q->where('created_by',$userId)),
            ],
            'customer_id' => ['required','integer','exists:customers,id'],
            'issue_date'  => ['required','date'],
            'due_date'    => ['required','date','after_or_equal:issue_date'],
            'send_date'   => ['nullable','date'],
            'category_id' => ['required','integer'],
            'ref_number'  => ['nullable','string'],
            'status'      => ['nullable','integer'],
            'shipping_display' => ['nullable','boolean'],
            'discount_apply'   => ['nullable','boolean'],
        ];
    }
}
