<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreCustomerRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $userId = $this->user()->id ?? 0;

        return [
            'customer_id' => [
                'required','integer',
                Rule::unique('customers','customer_id')->where(fn($q)=>$q->where('created_by',$userId)),
            ],
            'name'   => 'nullable|string|max:191',
            'email'  => [
                'nullable','email','max:191',
                Rule::unique('customers','email')->where(fn($q)=>$q->where('created_by',$userId)),
            ],
            'tax_number' => 'nullable|string|max:191',
            'contact'    => 'nullable|string|max:191',
            'avatar'     => 'nullable|string|max:100',
            'is_active'  => 'nullable|boolean',

            // Billing
            'billing_name'    => 'nullable|string|max:191',
            'billing_country' => 'nullable|string|max:191',
            'billing_state'   => 'nullable|string|max:191',
            'billing_city'    => 'nullable|string|max:191',
            'billing_phone'   => 'nullable|string|max:191',
            'billing_zip'     => 'nullable|string|max:191',
            'billing_address' => 'nullable|string',

            // Shipping
            'shipping_name'    => 'nullable|string|max:191',
            'shipping_country' => 'nullable|string|max:191',
            'shipping_state'   => 'nullable|string|max:191',
            'shipping_city'    => 'nullable|string|max:191',
            'shipping_phone'   => 'nullable|string|max:191',
            'shipping_zip'     => 'nullable|string|max:191',
            'shipping_address' => 'nullable|string',

            'lang'      => 'nullable|string|max:191',
            'balance'   => 'nullable|numeric',
        ];
    }
}
